loadFillTypes = {}

local modDir = g_currentModDirectory
local modName = g_currentModName

function loadFillTypes.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    superFunc(self, xmlFile, missionInfo, baseDirectory)
    local xmlFilename = Utils.getFilename('xml/fillTypes.xml', modDir)

    if xmlFilename == nil then
        Logging.xmlInfo(xmlFile, "No fillTypes xml defined in mod")

        return false
    end

    local fillTypesXmlFile = XMLFile.load("fillTypes", xmlFilename, FillTypeManager.xmlSchema)

    if fillTypesXmlFile ~= nil then
        g_fillTypeManager:loadFillTypes(fillTypesXmlFile, modDir , false, modName)
        fillTypesXmlFile:delete()
    end

    for _, fruitType in ipairs(self.fillTypes) do
        fruitType:finalize()
    end

    return true
end

FillTypeManager.loadMapData = Utils.overwrittenFunction(FillTypeManager.loadMapData, loadFillTypes.loadMapData)