--[[
	AllowTurnOffLevelerNodeForShovels.lua
	
	Autor: 		Ifko[nator]
	Datum: 		09.07.2023
	Version: 	1.1
	
	Changelog:	v1.0 @25.06.2023 - initial implementation in FS 22
				--------------------------------------------------
				v1.1 @09.07.2023 - fix for missing l10n entry
]]

AllowTurnOffLevelerNodeForShovels = {};
AllowTurnOffLevelerNodeForShovels.currentModName = "";

for _, mod in pairs(g_modManager.mods) do
	if mod.title:lower() == "abschaltbare schiebeschildfunktion für schaufeln" or mod.title:lower() == "deactivatable leveler function for shovels" then		
		if g_modIsLoaded[tostring(mod.modName)] then	
			AllowTurnOffLevelerNodeForShovels.currentModName = mod.modName;
			
			break;
		end;
	end;
end;

local function getSpecByName(self, specName, currentModName)
    local spec = self["spec_" .. Utils.getNoNil(currentModName, AllowTurnOffLevelerNodeForShovels.currentModName) .. "." .. specName];

	if spec ~= nil then
        return spec;
    end;

    return self["spec_" .. specName];
end;

local function getL10nText(text)
	if text:sub(1, 6) == "$l10n_" then
		text = g_i18n:getText(text:sub(7), AllowTurnOffLevelerNodeForShovels.currentModName);
	elseif g_i18n:hasText(text, AllowTurnOffLevelerNodeForShovels.currentModName) then
		text = g_i18n:getText(text, AllowTurnOffLevelerNodeForShovels.currentModName);
	end;

	return text;
end;

function AllowTurnOffLevelerNodeForShovels.initSpecialization()
	local schemaSavegame = Vehicle.xmlSchemaSavegame;

	schemaSavegame:register(XMLValueType.BOOL, "vehicles.vehicle(?).allowTurnOffLevelerNodeForShovels#isActive", "Allow leveler node for shovel.", false);

end;

function AllowTurnOffLevelerNodeForShovels.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Shovel, specializations);
end;

function AllowTurnOffLevelerNodeForShovels.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdateTick",
		"onRegisterActionEvents"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, AllowTurnOffLevelerNodeForShovels);
	end;
end;

function AllowTurnOffLevelerNodeForShovels.registerFunctions(vehicleType)
	local functionNames = {
		"setLevelerActive"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerFunction(vehicleType, functionName, AllowTurnOffLevelerNodeForShovels[functionName]);
	end;
end;

function AllowTurnOffLevelerNodeForShovels.registerOverwrittenFunctions(vehicleType)
	local functionNames = {
		"getIsLevelerPickupNodeActive"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerOverwrittenFunction(vehicleType, functionName, AllowTurnOffLevelerNodeForShovels[functionName]);
	end;
end;

function AllowTurnOffLevelerNodeForShovels:onLoad(savegame)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");

	specAllowTurnOffLevelerNodeForShovels.isActive = false;
	
	if savegame ~= nil and not savegame.resetVehicles then
		specAllowTurnOffLevelerNodeForShovels.isActive = savegame.xmlFile:getValue(savegame.key .. ".allowTurnOffLevelerNodeForShovels#isActive", specAllowTurnOffLevelerNodeForShovels.isActive);
	end;

	specAllowTurnOffLevelerNodeForShovels.l10nTexts = {};

	local l10nTexts = {
		"ACTIVATE_LEVELER",
		"DEACTIVATE_LEVELER"
	};

	for _, l10nText in pairs(l10nTexts) do
		specAllowTurnOffLevelerNodeForShovels.l10nTexts[l10nText] = getL10nText(l10nText);
	end;

    self:setLevelerActive(specAllowTurnOffLevelerNodeForShovels.isActive, false);
end;

function AllowTurnOffLevelerNodeForShovels:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");

    if self.isClient then
		local levelerButton = specAllowTurnOffLevelerNodeForShovels.actionEvents[InputAction.SWITCH_LEVELER_ACTIVE_BUTTON];
        
        if levelerButton ~= nil then
            local currentText = specAllowTurnOffLevelerNodeForShovels.l10nTexts.ACTIVATE_LEVELER;
            
            if specAllowTurnOffLevelerNodeForShovels.isActive then
                currentText = specAllowTurnOffLevelerNodeForShovels.l10nTexts.DEACTIVATE_LEVELER;
            end;
            
            g_inputBinding:setActionEventText(levelerButton.actionEventId, currentText);
        end;
    end;
end;

function AllowTurnOffLevelerNodeForShovels:onRegisterActionEvents(isActiveForInput)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");
	
	if self.isClient then        
		self:clearActionEventsTable(specAllowTurnOffLevelerNodeForShovels.actionEvents);
        
		if self:getIsActiveForInput(true) then
            local actionEventId;
            
			_, actionEventId = self:addActionEvent(specAllowTurnOffLevelerNodeForShovels.actionEvents, InputAction.SWITCH_LEVELER_ACTIVE_BUTTON, self, AllowTurnOffLevelerNodeForShovels.toggleLevelerActive, false, true, false, true, nil);
			
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_HIGH);
			g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			g_inputBinding:setActionEventActive(actionEventId, self.xmlFile:hasProperty("vehicle.leveler.levelerNode") and self.spec_leveler ~= nil);
		end;
	end;
end;

function AllowTurnOffLevelerNodeForShovels.toggleLevelerActive(self, actionName, inputValue, callbackState, isAnalog)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");
	
	self:setLevelerActive(not specAllowTurnOffLevelerNodeForShovels.isActive, false);
end;

function AllowTurnOffLevelerNodeForShovels:getIsLevelerPickupNodeActive(superFunc, levelerNode)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");
	
	return self.getAttacherVehicle == nil or self:getAttacherVehicle() ~= nil and specAllowTurnOffLevelerNodeForShovels.isActive;
end;

function AllowTurnOffLevelerNodeForShovels:setLevelerActive(isActive, noEventSend)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");
	
	if isActive ~= specAllowTurnOffLevelerNodeForShovels.isActive then
		specAllowTurnOffLevelerNodeForShovels.isActive = isActive;
		
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(AllowTurnOffLevelerNodeForShovelsEvent.new(self, isActive), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(AllowTurnOffLevelerNodeForShovelsEvent.new(self, isActive));
			end;
		end;
	end;
end;

function AllowTurnOffLevelerNodeForShovels:saveToXMLFile(xmlFile, key, usedModNames)
	local specAllowTurnOffLevelerNodeForShovels = getSpecByName(self, "allowTurnOffLevelerNodeForShovels");

    xmlFile:setValue(key .. "#isActive", specAllowTurnOffLevelerNodeForShovels.isActive);
end;

--------------------------------------------------------------------------------------------------
--## MP Stuff
--## turn leveler node from shovel on/off
--------------------------------------------------------------------------------------------------

AllowTurnOffLevelerNodeForShovelsEvent = {};
AllowTurnOffLevelerNodeForShovelsEvent_mt = Class(AllowTurnOffLevelerNodeForShovelsEvent, Event);

InitEventClass(AllowTurnOffLevelerNodeForShovelsEvent, "AllowTurnOffLevelerNodeForShovelsEvent");

function AllowTurnOffLevelerNodeForShovelsEvent.emptyNew()
	local self = Event.new(AllowTurnOffLevelerNodeForShovelsEvent_mt);
    
	return self;
end;

function AllowTurnOffLevelerNodeForShovelsEvent.new(shovel, isActive)
	local self = AllowTurnOffLevelerNodeForShovelsEvent.emptyNew();
	
	self.shovel = shovel;
	self.isActive = isActive;
	
	return self;
end;

function AllowTurnOffLevelerNodeForShovelsEvent:readStream(streamId, connection)
	self.shovel = NetworkUtil.readNodeObject(streamId);
	self.isActive = streamReadBool(streamId);
	
    self:run(connection);
end;

function AllowTurnOffLevelerNodeForShovelsEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.shovel);
	
	streamWriteBool(streamId, self.isActive);
end;

function AllowTurnOffLevelerNodeForShovelsEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(AllowTurnOffLevelerNodeForShovelsEvent.new(self.shovel, self.isActive), nil, connection, self.shovel);
	end;
	
    if self.shovel ~= nil then
        self.shovel:setLevelerActive(self.isActive, true);
	end;
end;